% k-Wave Toolbox for photoacoustic wave simulation and image reconstruction
% Version B.0.1 (first beta release)
% Created: July 2009
% Authors: Bradley Treeby and Ben Cox    
%
% See k-Wave Toolbox in help menu for description and examples.
% Type "help <command-name>" for documentation on individual commands.
% -----------------------------------------------------------------
%
% Wave Propagation
%  kspaceFirstOrder1D   - 1D time-domain simulation of wave propagation.
%  kspaceFirstOrder2D   - 2D time-domain simulation of wave propagation.
%  kspaceFirstOrder3D   - 3D time-domain simulation of wave propagation.
% 
% Image Reconstruction
%  kspaceLineRecon      - 2D linear FFT reconstruction.
%  kspacePlaneRecon     - 3D planar FFT reconstruction.
% 
% Geometry Creation
%  makeBall             - Create a binary map of filled ball within a 3D grid.
%  makeCartCircle       - Create a 2D Cartesian circle or arc.
%  makeCartSphere       - Create a 3D Cartesian sphere.
%  makeCircle           - Create a binary map of a circle within a 2D grid.
%  makeDisc             - Create a binary map of a filled disc within a 2D grid.
%  makeSphere           - Create a binary map of a sphere within a 3D grid.
% 
% Utilities
%  cart2grid            - Interpolate a set of Cartesian points onto a binary grid.
%  flyThrough           - Display a three-dimensional matrix slice by slice.
%  getColorMap          - Return default k-Wave color map.
%  getkWavePath         - Return pathname to the k-Wave Toolbox.
%  interpCartData       - Interpolate data from a Cartesian to a binary sensor mask.
%  loadImage            - Load an image file.
%  makeGrid             - Create k-space grid structure.
%  makeTime             - Create an evenly spaced array of time points.
%  resize               - Resize a matrix using interp2.
%  smooth               - Smooth a matrix.
%  unmaskSensorData     - Reorder data recorded using a binary sensor mask.